
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x = model.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bobby", "Dale", "Peggy", "Paul", "John"])


# Set objective function
model.setObjective(7.36*x[0] + 9.14*x[1] + 6.94*x[2] + 1.22*x[3] + 5.42*x[4], gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4*x[0] + 2*x[2] >= 13)
model.addConstr(2*x[1] + 2*x[2] >= 11)
model.addConstr(2*x[2] + 1*x[4] >= 5)
model.addConstr(7*x[3] + 1*x[4] >= 5)
model.addConstr(4*x[0] + 2*x[1] + 2*x[2] + 7*x[3] + 1*x[4] >= 5)
model.addConstr(2*x[0] + 1*x[3] >= 10)
model.addConstr(2*x[0] + 1*x[1] >= 5)
model.addConstr(2*x[0] + 2*x[2] >= 13)
model.addConstr(2*x[0] + 1*x[1] + 2*x[2] + 1*x[3] + 5*x[4] >= 13)
model.addConstr(-5*x[2] + 4*x[4] >= 0)
model.addConstr(2*x[1] + 2*x[2] <= 33)
model.addConstr(4*x[0] + 2*x[2] <= 81)
model.addConstr(2*x[1] + 1*x[4] <= 24)
model.addConstr(2*x[1] + 2*x[2] + 7*x[3] <= 50)
model.addConstr(2*x[1] + 7*x[3] + 1*x[4] <= 25)
model.addConstr(1*x[1] + 1*x[3] <= 50)
model.addConstr(1*x[1] + 5*x[4] <= 72)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

