
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bobby
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Dale
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Paul
    x4 = model.addVar(name="x4", lb=0)  # hours worked by John

    # Objective function
    model.setObjective(7.36 * x0 + 9.14 * x1 + 6.94 * x2 + 1.22 * x3 + 5.42 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 + 2 * x2 >= 13)
    model.addConstr(2 * x1 + 2 * x2 >= 11)
    model.addConstr(2 * x2 + x4 >= 5)
    model.addConstr(7 * x3 + x4 >= 5)
    model.addConstr(4 * x0 + 2 * x1 + 2 * x2 + 7 * x3 + x4 >= 5)
    model.addConstr(2 * x0 + x3 >= 10)
    model.addConstr(2 * x0 + x1 >= 5)
    model.addConstr(2 * x0 + 2 * x2 >= 13)
    model.addConstr(2 * x0 + x1 + 2 * x2 + x3 + 5 * x4 >= 13)
    model.addConstr(-5 * x2 + 4 * x4 >= 0)
    model.addConstr(2 * x1 + 2 * x2 <= 33)
    model.addConstr(4 * x0 + 2 * x2 <= 81)
    model.addConstr(2 * x1 + x4 <= 24)
    model.addConstr(2 * x1 + 2 * x2 + 7 * x3 <= 50)
    model.addConstr(2 * x1 + 7 * x3 + x4 <= 25)
    model.addConstr(x1 + x3 <= 50)
    model.addConstr(x1 + 5 * x4 <= 72)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Dale: ", x1.varValue)
        print("Hours worked by Peggy: ", x2.varValue)
        print("Hours worked by Paul: ", x3.varValue)
        print("Hours worked by John: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
