
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")


    # Set objective function
    m.setObjective(4*x0 + 5*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x0 + 14*x1 >= 81, "deployment_weight_min")
    m.addConstr(2*x0 + 1*x1 >= 58, "fun_factor_min")
    m.addConstr(-2*x0 + 7*x1 >= 0, "recon_engineer_relation")
    m.addConstr(16*x0 + 14*x1 <= 163, "deployment_weight_max")
    m.addConstr(2*x0 + 1*x1 <= 116, "fun_factor_max")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('reconnaissance_troops:', x0.x)
        print('engineer_platoons:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

