
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="engineer_platoons")

# Set the objective function
m.setObjective(4*x0 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x0 + 14*x1 >= 81, "Minimum_Deployment_Weight")
m.addConstr(2*x0 + 1*x1 >= 58, "Minimum_Fun_Factor")
m.addConstr(-2*x0 + 7*x1 >= 0, "Linear_Constraint")
m.addConstr(16*x0 + 14*x1 <= 177, "Maximum_Deployment_Weight")
m.addConstr(2*x0 + 1*x1 <= 116, "Maximum_Fun_Factor")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance Troops: {x0.x}")
    print(f"Engineer Platoons: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
