
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="engineer_platoons", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(16 * x1 + 14 * x2 >= 81, name="deployment_weight_min")
model.addConstr(2 * x1 + x2 >= 58, name="fun_factor_min")
model.addConstr(-2 * x1 + 7 * x2 >= 0, name="troops_platoons_balance")
model.addConstr(16 * x1 + 14 * x2 <= 163, name="deployment_weight_max")
model.addConstr(2 * x1 + x2 <= 116, name="fun_factor_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance troops: {x1.varValue}")
    print(f"Engineer platoons: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
