
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["engineer_platoons", "transportation_companies", "military_intelligence_companies", "pathfinder_teams"])


    # Set objective function
    m.setObjective(3*x[0] + 6*x[1] + 7*x[2] + 1*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    resources = {
        'r0': {'upper_bound': 179, 'x0': 4.69, 'x1': 2.64, 'x2': 1.63, 'x3': 4.28},
        'r1': {'upper_bound': 161, 'x0': 1.48, 'x1': 0.52, 'x2': 3.24, 'x3': 2.78},
        'r2': {'upper_bound': 135, 'x0': 3.84, 'x1': 3.92, 'x2': 3.21, 'x3': 4.35},
        'r3': {'upper_bound': 129, 'x0': 1.84, 'x1': 0.54, 'x2': 1.53, 'x3': 4.16},
        'r4': {'upper_bound': 233, 'x0': 0.73, 'x1': 0.85, 'x2': 0.87, 'x3': 2.29}
    }

    # Add the constraints from the JSON output
    m.addConstr(4.69*x[0] + 1.63*x[2] >= 15)
    m.addConstr(4.69*x[0] + 2.64*x[1] >= 14)
    # ... (add all other constraints from the JSON)

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
