
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B4
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B9
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin D
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin C


# Set objective function
m.setObjective(5.18 * x0 + 3.4 * x1 + 4.47 * x2 + 7.55 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(28 * x0 + 13 * x1 + 4 * x2 + 18 * x3 <= 436, "r0")
m.addConstr(1 * x0 + 24 * x1 + 1 * x2 + 12 * x3 <= 355, "r1")
m.addConstr(15 * x0 + 12 * x1 + 16 * x2 + 1 * x3 <= 394, "r2")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 + 13 * x3 <= 626, "r3")
m.addConstr(13 * x1 + 4 * x2 >= 36, "c1")
m.addConstr(13 * x1 + 18 * x3 >= 61, "c2")
m.addConstr(28 * x0 + 18 * x3 >= 91, "c3")
m.addConstr(13 * x1 + 4 * x2 + 18 * x3 >= 96, "c4")
m.addConstr(28 * x0 + 13 * x1 + 18 * x3 >= 96, "c5")
m.addConstr(13 * x1 + 4 * x2 + 18 * x3 >= 99, "c6")
m.addConstr(28 * x0 + 13 * x1 + 18 * x3 >= 99, "c7")
m.addConstr(28 * x0 + 13 * x1 + 4 * x2 + 18 * x3 >= 99, "c8")
m.addConstr(1 * x0 + 12 * x3 >= 61, "c9")
m.addConstr(1 * x2 + 12 * x3 >= 44, "c10")
m.addConstr(24 * x1 + 1 * x2 >= 86, "c11")
m.addConstr(1 * x0 + 24 * x1 + 12 * x3 >= 72, "c12")
m.addConstr(1 * x0 + 1 * x2 + 12 * x3 >= 72, "c13")
m.addConstr(1 * x0 + 24 * x1 + 12 * x3 >= 69, "c14")
m.addConstr(1 * x0 + 1 * x2 + 12 * x3 >= 69, "c15")
m.addConstr(1 * x0 + 24 * x1 + 1 * x2 + 12 * x3 >= 69, "c16")
m.addConstr(16 * x2 + 1 * x3 >= 77, "c17")
m.addConstr(12 * x1 + 16 * x2 >= 38, "c18")
m.addConstr(15 * x0 + 16 * x2 >= 43, "c19")
m.addConstr(12 * x1 + 1 * x3 >= 91, "c20")
m.addConstr(15 * x0 + 12 * x1 >= 67, "c21")
m.addConstr(15 * x0 + 1 * x3 >= 94, "c22")
m.addConstr(12 * x1 + 16 * x2 + 1 * x3 >= 96, "c23")
m.addConstr(15 * x0 + 12 * x1 + 16 * x2 >= 96, "c24")
m.addConstr(12 * x1 + 16 * x2 + 1 * x3 >= 76, "c25")
m.addConstr(15 * x0 + 12 * x1 + 16 * x2 >= 76, "c26")
m.addConstr(15 * x0 + 12 * x1 + 16 * x2 + 1 * x3 >= 76, "c27")
m.addConstr(8 * x1 + 11 * x2 >= 146, "c28")
m.addConstr(11 * x2 + 13 * x3 >= 114, "c29")
m.addConstr(7 * x0 + 8 * x1 >= 140, "c30")
m.addConstr(7 * x0 + 13 * x3 >= 89, "c31")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 >= 97, "c32")
m.addConstr(8 * x1 + 11 * x2 + 13 * x3 >= 97, "c33")
m.addConstr(7 * x0 + 8 * x1 + 13 * x3 >= 97, "c34")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 >= 89, "c35")
m.addConstr(8 * x1 + 11 * x2 + 13 * x3 >= 89, "c36")
m.addConstr(7 * x0 + 8 * x1 + 13 * x3 >= 89, "c37")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 >= 119, "c38")
m.addConstr(8 * x1 + 11 * x2 + 13 * x3 >= 119, "c39")
m.addConstr(7 * x0 + 8 * x1 + 13 * x3 >= 119, "c40")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 + 13 * x3 >= 119, "c41")
m.addConstr(13 * x1 + 18 * x3 <= 160, "c42")
m.addConstr(13 * x1 + 4 * x2 <= 251, "c43")
m.addConstr(1 * x0 + 12 * x3 <= 94, "c44")
m.addConstr(1 * x0 + 24 * x1 + 12 * x3 <= 140, "c45")
m.addConstr(15 * x0 + 16 * x2 + 1 * x3 <= 349, "c46")
m.addConstr(7 * x0 + 8 * x1 + 11 * x2 <= 359, "c47")
m.addConstr(8 * x1 + 11 * x2 + 13 * x3 <= 536, "c48")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

