
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B4
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B9
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY)  # milligrams of vitamin D
x3 = m.addVar(name="x3", lb=-gp.GRB.INFINITY)  # milligrams of vitamin C

# Define the objective function
m.setObjective(5.18*x0 + 3.4*x1 + 4.47*x2 + 7.55*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(28*x0 <= 436)
m.addConstr(x0 <= 355)
m.addConstr(15*x0 <= 394)
m.addConstr(7*x0 <= 626)
m.addConstr(13*x1 <= 436)
m.addConstr(24*x1 <= 355)
m.addConstr(12*x1 <= 394)
m.addConstr(8*x1 <= 626)
m.addConstr(4*x2 <= 436)
m.addConstr(x2 <= 355)
m.addConstr(16*x2 <= 394)
m.addConstr(11*x2 <= 626)
m.addConstr(18*x3 <= 436)
m.addConstr(12*x3 <= 355)
m.addConstr(x3 <= 394)
m.addConstr(13*x3 <= 626)
m.addConstr(13*x1 + 4*x2 >= 36)
m.addConstr(13*x1 + 18*x3 >= 61)
m.addConstr(28*x0 + 18*x3 >= 91)
m.addConstr(13*x1 + 4*x2 + 18*x3 >= 96)
m.addConstr(28*x0 + 13*x1 + 18*x3 >= 96)
m.addConstr(13*x1 + 4*x2 + 18*x3 >= 99)
m.addConstr(28*x0 + 13*x1 + 18*x3 >= 99)
m.addConstr(28*x0 + 13*x1 + 4*x2 + 18*x3 >= 99)
m.addConstr(x0 + 12*x3 >= 61)
m.addConstr(x2 + 12*x3 >= 44)
m.addConstr(24*x1 + x2 >= 86)
m.addConstr(x0 + 24*x1 + 12*x3 >= 72)
m.addConstr(x0 + x2 + 12*x3 >= 72)
m.addConstr(x0 + 24*x1 + 12*x3 >= 69)
m.addConstr(x0 + x2 + 12*x3 >= 69)
m.addConstr(x0 + x1 + x2 + 12*x3 >= 69)
m.addConstr(16*x2 + x3 >= 77)
m.addConstr(12*x1 + 16*x2 >= 38)
m.addConstr(15*x0 + 16*x2 >= 43)
m.addConstr(12*x1 + x3 >= 91)
m.addConstr(15*x0 + 12*x1 >= 67)
m.addConstr(15*x0 + x3 >= 94)
m.addConstr(12*x1 + 16*x2 + x3 >= 96)
m.addConstr(15*x0 + 12*x1 + 16*x2 >= 96)
m.addConstr(12*x1 + 16*x2 + x3 >= 76)
m.addConstr(15*x0 + 12*x1 + 16*x2 >= 76)
m.addConstr(15*x0 + 12*x1 + 16*x2 + x3 >= 76)
m.addConstr(8*x1 + 11*x2 >= 146)
m.addConstr(11*x2 + 13*x3 >= 114)
m.addConstr(7*x0 + 8*x1 >= 140)
m.addConstr(7*x0 + 13*x3 >= 89)
m.addConstr(7*x0 + 8*x1 + 11*x2 >= 97)
m.addConstr(8*x1 + 11*x2 + 13*x3 >= 97)
m.addConstr(7*x0 + 8*x1 + 13*x3 >= 97)
m.addConstr(7*x0 + 8*x1 + 11*x2 >= 89)
m.addConstr(8*x1 + 11*x2 + 13*x3 >= 89)
m.addConstr(7*x0 + 8*x1 + 13*x3 >= 89)
m.addConstr(7*x0 + 8*x1 + 11*x2 >= 119)
m.addConstr(8*x1 + 11*x2 + 13*x3 >= 119)
m.addConstr(7*x0 + 8*x1 + 13*x3 >= 119)
m.addConstr(7*x0 + 8*x1 + 11*x2 + 13*x3 >= 119)
m.addConstr(13*x1 + 18*x3 <= 160)
m.addConstr(13*x1 + 4*x2 <= 251)
m.addConstr(x0 + 12*x3 <= 94)
m.addConstr(x0 + 24*x1 + 12*x3 <= 140)
m.addConstr(15*x0 + 16*x2 + x3 <= 349)
m.addConstr(7*x0 + 8*x1 + 11*x2 <= 359)
m.addConstr(8*x1 + 11*x2 + 13*x3 <= 536)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x0: {x0.varValue}")
    print(f"x1: {x1.varValue}")
    print(f"x2: {x2.varValue}")
    print(f"x3: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
