
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pickles = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
oranges = m.addVar(lb=0, vtype=GRB.INTEGER, name="oranges")


# Set objective function
m.setObjective(4*pickles**2 + 6*pickles*oranges + 1*oranges**2 + 6*oranges, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*pickles + 9*oranges >= 17, "umami_index_lower_bound")
m.addConstr(1*pickles + 5*oranges >= 34, "cost_lower_bound")
m.addConstr(-5*pickles + 3*oranges >= 0, "pickles_oranges_relation")
m.addConstr(6*pickles**2 + 9*oranges**2 <= 38, "umami_index_squared_upper_bound")
m.addConstr(1*pickles**2 + 5*oranges**2 <= 39, "cost_squared_upper_bound")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Pickles: {pickles.x}")
    print(f"Oranges: {oranges.x}")
    print(f"Objective value: {m.objVal}")

