
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")
x2 = m.addVar(vtype=GRB.INTEGER, name="oranges")

# Set the objective function
m.setObjective(4*(x1)**2 + 6*(x1)*(x2) + (x2)**2 + 6*(x2), GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 9*x2 >= 17, name="umami_index_constraint")
m.addConstr(x1 + 5*x2 >= 34, name="cost_constraint")
m.addConstr(-5*x1 + 3*x2 >= 0, name="additional_linear_constraint")
m.addConstr((6*x1)**2 + (9*x2)**2 <= 38, name="squared_umami_index_constraint")
m.addConstr((x1)**2 + (5*x2)**2 <= 39, name="squared_cost_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pickles: {x1.x}")
    print(f"Oranges: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
