
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="pickles", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="oranges", lb=0, ub=gurobi.GRB.INFINITY, integrality=gurobi.GRB.INTEGER)

    # Set objective function
    model.setObjective(4*x1**2 + 6*x1*x2 + x2**2 + 6*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x1 + 9*x2 >= 17, name="umami_index_constraint")
    model.addConstr(x1 + 5*x2 >= 34, name="dollar_cost_constraint")
    model.addConstr(-5*x1 + 3*x2 >= 0, name="linear_constraint")
    model.addConstr(36*x1**2 + 81*x2**2 <= 38, name="umami_index_squared_constraint")
    model.addConstr(x1**2 + 25*x2**2 <= 39, name="dollar_cost_squared_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pickles: {x1.varValue}")
        print(f"Oranges: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
