
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("carbohydrate_optimization")

    # Create variables
    blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
    bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
    sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")

    # Set objective function
    m.setObjective(9 * blueberry_pies + 5 * pickles + 1 * bowls_of_pasta + 7 * sashimi, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * blueberry_pies + 7 * sashimi >= 36)
    m.addConstr(2 * blueberry_pies + 5 * pickles >= 18)
    m.addConstr(5 * pickles + 3 * bowls_of_pasta >= 31)
    m.addConstr(3 * bowls_of_pasta + 7 * sashimi >= 24)
    m.addConstr(5 * pickles + 7 * sashimi >= 47)
    m.addConstr(2 * blueberry_pies + 5 * pickles + 7 * sashimi >= 36)
    m.addConstr(2 * blueberry_pies + 3 * bowls_of_pasta + 7 * sashimi >= 36)
    m.addConstr(2 * blueberry_pies + 5 * pickles + 7 * sashimi >= 43)
    m.addConstr(2 * blueberry_pies + 3 * bowls_of_pasta + 7 * sashimi >= 43)
    m.addConstr(2 * blueberry_pies + 5 * pickles + 3 * bowls_of_pasta + 7 * sashimi >= 43)
    m.addConstr(-2 * blueberry_pies + 2 * pickles >= 0)
    m.addConstr(5 * pickles + 7 * sashimi <= 57)
    m.addConstr(2 * blueberry_pies + 5 * pickles + 3 * bowls_of_pasta <= 143)
    m.addConstr(2 * blueberry_pies + 3 * bowls_of_pasta + 7 * sashimi <= 181)
    m.addConstr(5 * pickles + 3 * bowls_of_pasta + 7 * sashimi <= 125)
    m.addConstr(2 * blueberry_pies + 5 * pickles + 3 * bowls_of_pasta + 7 * sashimi <= 207)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
