
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='blueberry_pies', lb=0)  # No lower bound specified, assuming 0
x2 = model.addVar(name='pickles', lb=0)  # No lower bound specified, assuming 0
x3 = model.addVar(name='bowls_of_pasta', lb=0, integrality=gurobi.GRB.INTEGER)  # Integer variable
x4 = model.addVar(name='sashimi', lb=0)  # No lower bound specified, assuming 0

# Objective function
model.setObjective(9 * x1 + 5 * x2 + x3 + 7 * x4, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(2 * x1 + 5 * x2 + 3 * x3 + 7 * x4 <= 207)
model.addConstr(2 * x1 + 7 * x4 >= 36)
model.addConstr(2 * x1 + 5 * x2 >= 18)
model.addConstr(5 * x2 + 3 * x3 >= 31)
model.addConstr(3 * x3 + 7 * x4 >= 24)
model.addConstr(5 * x2 + 7 * x4 >= 47)
model.addConstr(2 * x1 + 5 * x2 + 7 * x4 >= 36)
model.addConstr(2 * x1 + 3 * x3 + 7 * x4 >= 36)
model.addConstr(2 * x1 + 5 * x2 + 3 * x3 + 7 * x4 >= 43)
model.addConstr(2 * x1 + 5 * x2 + 7 * x4 >= 43)
model.addConstr(2 * x1 + 3 * x3 + 7 * x4 >= 43)
model.addConstr(-2 * x1 + 2 * x2 >= 0)
model.addConstr(5 * x2 + 7 * x4 <= 57)
model.addConstr(2 * x1 + 5 * x2 + 3 * x3 <= 143)
model.addConstr(2 * x1 + 3 * x3 + 7 * x4 <= 181)
model.addConstr(5 * x2 + 3 * x3 + 7 * x4 <= 125)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Blueberry pies: ', x1.varValue)
    print('Pickles: ', x2.varValue)
    print('Bowls of pasta: ', x3.varValue)
    print('Sashimi: ', x4.varValue)
else:
    print('The model is infeasible')
