
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")


# Set objective function
m.setObjective(7.6 * vitamin_c + 3.61 * vitamin_e + 1.44 * vitamin_b12 + 1.75 * carbohydrates + 6.75 * vitamin_b6, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * vitamin_b12 + 15 * carbohydrates >= 14)
m.addConstr(17 * vitamin_e + 6 * vitamin_b12 >= 25)
m.addConstr(15 * carbohydrates + 9 * vitamin_b6 >= 14)
m.addConstr(6 * vitamin_b12 + 9 * vitamin_b6 >= 25)
m.addConstr(18 * vitamin_c + 9 * vitamin_b6 >= 11)
m.addConstr(18 * vitamin_c + 6 * vitamin_b12 >= 22)
m.addConstr(18 * vitamin_c + 15 * carbohydrates >= 21)
m.addConstr(18 * vitamin_c + 17 * vitamin_e + 6 * vitamin_b12 + 15 * carbohydrates + 9 * vitamin_b6 >= 21)
m.addConstr(12 * vitamin_e + 9 * vitamin_b6 >= 36)
m.addConstr(12 * vitamin_e + 9 * vitamin_b12 >= 36)
m.addConstr(5 * carbohydrates + 9 * vitamin_b6 >= 24)
m.addConstr(4 * vitamin_c + 9 * vitamin_b12 >= 23)
m.addConstr(9 * vitamin_b12 + 9 * vitamin_b6 >= 15)
m.addConstr(9 * vitamin_b12 + 5 * carbohydrates >= 33)
m.addConstr(4 * vitamin_c + 9 * vitamin_b6 >= 30)
m.addConstr(4 * vitamin_c + 5 * carbohydrates >= 31)
m.addConstr(4 * vitamin_c + 12 * vitamin_e + 9 * vitamin_b12 >= 32)
m.addConstr(4 * vitamin_c + 12 * vitamin_e + 9 * vitamin_b12 + 5 * carbohydrates + 9 * vitamin_b6 >= 32)
m.addConstr(-7 * vitamin_c + 6 * vitamin_b12 >= 0)
m.addConstr(2 * vitamin_e - 3 * vitamin_b12 >= 0)
m.addConstr(18 * vitamin_c + 15 * carbohydrates <= 92)
m.addConstr(6 * vitamin_b12 + 9 * vitamin_b6 <= 115)
m.addConstr(17 * vitamin_e + 6 * vitamin_b12 <= 33)
m.addConstr(18 * vitamin_c + 6 * vitamin_b12 <= 87)
m.addConstr(15 * carbohydrates + 9 * vitamin_b6 <= 128)
m.addConstr(18 * vitamin_c + 17 * vitamin_e <= 113)
m.addConstr(17 * vitamin_e + 15 * carbohydrates + 9 * vitamin_b6 <= 116)
m.addConstr(18 * vitamin_c + 15 * carbohydrates + 9 * vitamin_b6 <= 132)
m.addConstr(18 * vitamin_c + 17 * vitamin_e + 15 * carbohydrates <= 89)
m.addConstr(18 * vitamin_c + 6 * vitamin_b12 + 9 * vitamin_b6 <= 51)
m.addConstr(17 * vitamin_e + 6 * vitamin_b12 + 15 * carbohydrates <= 123)
m.addConstr(18 * vitamin_c + 17 * vitamin_e + 9 * vitamin_b6 <= 36)
m.addConstr(18 * vitamin_c + 6 * vitamin_b12 + 15 * carbohydrates <= 116)
m.addConstr(9 * vitamin_b12 + 9 * vitamin_b6 <= 40)
m.addConstr(12 * vitamin_e + 9 * vitamin_b12 <= 179)
m.addConstr(4 * vitamin_c + 9 * vitamin_b6 <= 164)
m.addConstr(4 * vitamin_c + 9 * vitamin_b12 + 9 * vitamin_b6 <= 84)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

