
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=0, name="x0")  # milligrams of vitamin C
x1 = model.addVar(lb=0, name="x1")  # milligrams of vitamin E
x2 = model.addVar(lb=0, name="x2")  # milligrams of vitamin B12
x3 = model.addVar(lb=0, name="x3")  # grams of carbohydrates
x4 = model.addVar(lb=0, name="x4")  # milligrams of vitamin B6

# Define the objective function
model.setObjective(7.6 * x0 + 3.61 * x1 + 1.44 * x2 + 1.75 * x3 + 6.75 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * x0 <= 134)
model.addConstr(4 * x0 <= 186)
model.addConstr(17 * x1 <= 134)
model.addConstr(12 * x1 <= 186)
model.addConstr(6 * x2 <= 134)
model.addConstr(9 * x2 <= 186)
model.addConstr(15 * x3 <= 134)
model.addConstr(5 * x3 <= 186)
model.addConstr(9 * x4 <= 134)
model.addConstr(9 * x4 <= 186)
model.addConstr(6 * x2 + 15 * x3 >= 14)
model.addConstr(17 * x1 + 6 * x2 >= 25)
model.addConstr(15 * x3 + 9 * x4 >= 14)
model.addConstr(6 * x2 + 9 * x4 >= 25)
model.addConstr(18 * x0 + 9 * x4 >= 11)
model.addConstr(18 * x0 + 6 * x2 >= 22)
model.addConstr(18 * x0 + 15 * x3 >= 21)
model.addConstr(18 * x0 + 17 * x1 + 6 * x2 + 15 * x3 + 9 * x4 >= 21)
model.addConstr(12 * x1 + 9 * x4 >= 36)
model.addConstr(12 * x1 + 9 * x2 >= 36)
model.addConstr(5 * x3 + 9 * x4 >= 24)
model.addConstr(4 * x0 + 9 * x2 >= 23)
model.addConstr(9 * x2 + 9 * x4 >= 15)
model.addConstr(9 * x2 + 5 * x3 >= 33)
model.addConstr(4 * x0 + 9 * x4 >= 30)
model.addConstr(4 * x0 + 5 * x3 >= 31)
model.addConstr(4 * x0 + 12 * x1 + 9 * x2 >= 32)
model.addConstr(4 * x0 + 12 * x1 + 9 * x2 + 5 * x3 + 9 * x4 >= 32)
model.addConstr(-7 * x0 + 6 * x2 >= 0)
model.addConstr(2 * x1 - 3 * x2 >= 0)
model.addConstr(18 * x0 + 15 * x3 <= 92)
model.addConstr(6 * x2 + 9 * x4 <= 115)
model.addConstr(17 * x1 + 6 * x2 <= 33)
model.addConstr(18 * x0 + 6 * x2 <= 87)
model.addConstr(15 * x3 + 9 * x4 <= 128)
model.addConstr(18 * x0 + 17 * x1 <= 113)
model.addConstr(17 * x1 + 15 * x3 + 9 * x4 <= 116)
model.addConstr(18 * x0 + 15 * x3 + 9 * x4 <= 132)
model.addConstr(18 * x0 + 17 * x1 + 15 * x3 <= 89)
model.addConstr(18 * x0 + 6 * x2 + 9 * x4 <= 51)
model.addConstr(17 * x1 + 6 * x2 + 15 * x3 <= 123)
model.addConstr(18 * x0 + 17 * x1 + 9 * x4 <= 36)
model.addConstr(18 * x0 + 6 * x2 + 15 * x3 <= 116)
model.addConstr(9 * x2 + 9 * x4 <= 40)
model.addConstr(12 * x1 + 9 * x2 <= 179)
model.addConstr(4 * x0 + 9 * x4 <= 164)
model.addConstr(4 * x0 + 9 * x2 + 9 * x4 <= 84)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin C: ", x0.varValue)
    print("Milligrams of vitamin E: ", x1.varValue)
    print("Milligrams of vitamin B12: ", x2.varValue)
    print("Grams of carbohydrates: ", x3.varValue)
    print("Milligrams of vitamin B6: ", x4.varValue)
    print("Objective function value: ", model.objVal)
else:
    print("No optimal solution found.")
