
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of potassium


    # Set objective function
    m.setObjective(1.66*x0**2 + 1.68*x0*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 1*x1 >= 25, "c0")
    m.addConstr(3*x0 + 13*x1 >= 10, "c1")
    m.addConstr(-9*x0 + 5*x1 >= 0, "c2")
    m.addConstr(4*x0 + 1*x1 <= 37, "c3")
    m.addConstr(3*x0 + 13*x1 <= 41, "c4")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

