
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables: x1 (integer), x2 (continuous)
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B6")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")

# Objective function
m.setObjective(1.66*x1**2 + 1.68*x1*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(4*x1 + x2 >= 25, "kidney_support_index_min")
m.addConstr(3*x1 + 13*x2 >= 10, "energy_stability_index_min")
m.addConstr(-9*x1 + 5*x2 >= 0, "constraint_1")
m.addConstr(4*x1 + x2 <= 37, "kidney_support_index_max")
m.addConstr(3*x1 + 13*x2 <= 41, "energy_stability_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B6: {x1.x}")
    print(f"Milligrams of Potassium: {x2.x}")
else:
    print("No optimal solution found.")
