
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_vitamin_B6", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="milligrams_of_potassium")

# Set the objective function
model.setObjective(1.66 * x1**2 + 1.68 * x1 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x1 + x2 >= 25, name="kidney_support_index_min")
model.addConstr(4 * x1 + x2 <= 37, name="kidney_support_index_max")
model.addConstr(3 * x1 + 13 * x2 >= 10, name="energy_stability_index_min")
model.addConstr(3 * x1 + 13 * x2 <= 41, name="energy_stability_index_max")
model.addConstr(-9 * x1 + 5 * x2 >= 0, name="linear_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B6: {x1.varValue}")
    print(f"Milligrams of potassium: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
