
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strips of bacon")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="cornichons")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices of pizza")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham sandwiches")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")


# Set objective function
m.setObjective(3*x0 + 7*x1 + 4*x2 + 5*x3 + 7*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.56*x1 + 2.69*x2 >= 16)
m.addConstr(2.69*x2 + 2.56*x3 >= 14)
m.addConstr(1.35*x0 + 0.56*x1 + 2.69*x2 + 2.56*x3 + 1.05*x4 >= 14)
m.addConstr(0.03*x0 + 1.67*x1 >= 11)
m.addConstr(0.03*x0 + 2.17*x4 >= 13)
m.addConstr(0.03*x0 + 1.67*x1 + 2.47*x2 + 0.59*x3 + 2.17*x4 >= 13)
m.addConstr(10*x0 - 5*x1 >= 0)
m.addConstr(1.35*x0 + 2.56*x3 <= 19)
m.addConstr(0.56*x1 + 2.69*x2 + 1.05*x4 <= 23)
m.addConstr(1.35*x0 + 2.56*x3 + 1.05*x4 <= 60)
m.addConstr(1.67*x1 + 2.17*x4 <= 59)
m.addConstr(1.67*x1 + 2.47*x2 <= 40)
m.addConstr(0.03*x0 + 1.67*x1 <= 161)
m.addConstr(0.59*x3 + 2.17*x4 <= 60)
m.addConstr(0.03*x0 + 0.59*x3 <= 127)
m.addConstr(0.03*x0 + 1.67*x1 + 2.17*x4 <= 57)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

