
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="strips_of_bacon", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="cornichons", lb=0, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)
x2 = m.addVar(name="slices_of_pizza", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="ham_sandwiches", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x4 = m.addVar(name="kiwis", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3*x0 + 7*x1 + 4*x2 + 5*x3 + 7*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.56*x1 + 2.69*x2 >= 16)
m.addConstr(2.69*x2 + 2.56*x3 >= 14)
m.addConstr(1.35*x0 + 0.56*x1 + 2.69*x2 + 2.56*x3 + 1.05*x4 >= 14)
m.addConstr(0.03*x0 + 1.67*x1 >= 11)
m.addConstr(0.03*x0 + 2.17*x4 >= 13)
m.addConstr(0.03*x0 + 1.67*x1 + 2.47*x2 + 0.59*x3 + 2.17*x4 >= 13)
m.addConstr(10*x0 - 5*x1 >= 0)
m.addConstr(1.35*x0 + 2.56*x3 <= 19)
m.addConstr(0.56*x1 + 2.69*x2 + 1.05*x4 <= 23)
m.addConstr(1.35*x0 + 2.56*x3 + 1.05*x4 <= 60)
m.addConstr(1.67*x1 + 2.17*x4 <= 59)
m.addConstr(1.67*x1 + 2.47*x2 <= 40)
m.addConstr(0.03*x0 + 1.67*x1 <= 161)
m.addConstr(0.59*x3 + 2.17*x4 <= 60)
m.addConstr(0.03*x0 + 0.59*x3 <= 127)
m.addConstr(0.03*x0 + 1.67*x1 + 2.17*x4 <= 57)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", x0.varValue)
    print("Cornichons: ", x1.varValue)
    print("Slices of pizza: ", x2.varValue)
    print("Ham sandwiches: ", x3.varValue)
    print("Kiwis: ", x4.varValue)
else:
    print("The model is infeasible")
