
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B12 (integer)
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # grams of fiber (continuous)


    # Set objective function
    m.setObjective(9.9 * x0 + 3.31 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2.77 * x0 + 2.33 * x1 >= 47, "c0")
    m.addConstr(2.15 * x0 + 1.94 * x1 >= 46, "c1")
    m.addConstr(-10 * x0 + 9 * x1 >= 0, "c2")
    m.addConstr(2.77 * x0 + 2.33 * x1 <= 51, "c3")
    m.addConstr(2.15 * x0 + 1.94 * x1 <= 138, "c4")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

