
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B12")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fiber")

# Set the objective function
model.setObjective(9.9*x1 + 3.31*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(2.77*x1 >= 0, "Muscle_Growth_Index_Vitamin_B12")
model.addConstr(2.15*x1 >= 0, "Cognitive_Performance_Index_Vitamin_B12")
model.addConstr(2.33*x2 >= 0, "Muscle_Growth_Index_Fiber")
model.addConstr(1.94*x2 >= 0, "Cognitive_Performance_Index_Fiber")
model.addConstr(2.77*x1 + 2.33*x2 >= 47, "Total_Muscle_Growth_Index_Minimum")
model.addConstr(2.15*x1 + 1.94*x2 >= 46, "Total_Cognitive_Performance_Index_Minimum")
model.addConstr(-10*x1 + 9*x2 >= 0, "Mixed_Constraint")
model.addConstr(2.77*x1 + 2.33*x2 <= 51, "Total_Muscle_Growth_Index_Maximum")
model.addConstr(2.15*x1 + 1.94*x2 <= 138, "Total_Cognitive_Performance_Index_Maximum")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B12: {x1.x}")
    print(f"Grams of Fiber: {x2.x}")
else:
    print("No optimal solution found")
