
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B12", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="grams_of_fiber")

    # Objective function
    model.setObjective(9.9 * x1 + 3.31 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2.77 * x1 + 2.33 * x2 >= 47)
    model.addConstr(2.15 * x1 + 1.94 * x2 >= 46)
    model.addConstr(-10 * x1 + 9 * x2 >= 0)
    model.addConstr(2.77 * x1 + 2.33 * x2 <= 51)
    model.addConstr(2.15 * x1 + 1.94 * x2 <= 138)

    # Non-negativity constraints (assuming x1 and x2 are non-negative)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
