
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    pizza = m.addVar(name="pizza")
    apple_pie = m.addVar(name="apple_pie")
    fruit_salad = m.addVar(name="fruit_salad")


    # Set objective function
    m.setObjective(4*pizza**2 + 6*pizza*apple_pie + 5*fruit_salad**2 + 2*apple_pie, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18*pizza + 11*apple_pie + 8*fruit_salad <= 287, "tastiness_rating")
    m.addConstr(23*pizza + 13*apple_pie + 21*fruit_salad <= 165, "carbohydrates")
    m.addConstr((18*pizza)**2 + (11*apple_pie)**2 >= 79, "tastiness_pizza_apple_pie")
    m.addConstr(11*apple_pie + 8*fruit_salad >= 36, "tastiness_apple_pie_fruit_salad")
    m.addConstr(18*pizza + 11*apple_pie + 8*fruit_salad >= 36, "tastiness_total")
    m.addConstr((23*pizza)**2 + (13*apple_pie)**2 >= 30, "carbohydrates_pizza_apple_pie")
    m.addConstr(13*apple_pie + 21*fruit_salad >= 22, "carbohydrates_apple_pie_fruit_salad")
    m.addConstr(23*pizza + 13*apple_pie + 21*fruit_salad >= 48, "carbohydrates_total")
    m.addConstr(6*pizza**2 - 2*fruit_salad**2 >= 0, "pizza_fruit_salad_relation")
    m.addConstr(10*apple_pie - 4*fruit_salad >= 0, "apple_pie_fruit_salad_relation")
    m.addConstr(18*pizza + 11*apple_pie <= 190, "tastiness_pizza_apple_pie_upper")
    m.addConstr(23*pizza + 13*apple_pie <= 117, "carbohydrates_pizza_apple_pie_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
