
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="slices_of_pizza", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = model.addVar(name="apple_pies", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="fruit_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
model.setObjective(4*x0**2 + 6*x0*x1 + 5*x2**2 + 2*x1, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(18*x0 == 18, name="tastiness_pizza")
model.addConstr(23*x0 <= 165, name="carbohydrates_pizza")
model.addConstr(11*x1 == 11, name="tastiness_apple_pies")
model.addConstr(13*x1 <= 165, name="carbohydrates_apple_pies")
model.addConstr(8*x2 == 8, name="tastiness_fruit_salads")
model.addConstr(21*x2 <= 165, name="carbohydrates_fruit_salads")
model.addConstr((18*x0)**2 + (11*x1)**2 >= 79, name="tastiness_pizza_apple_pies")
model.addConstr(11*x1 + 8*x2 >= 36, name="tastiness_apple_pies_fruit_salads")
model.addConstr(18*x0 + 11*x1 + 8*x2 >= 36, name="tastiness_total")
model.addConstr((23*x0)**2 + (13*x1)**2 >= 30, name="carbohydrates_pizza_apple_pies")
model.addConstr(13*x1 + 21*x2 >= 22, name="carbohydrates_apple_pies_fruit_salads")
model.addConstr(23*x0 + 13*x1 + 21*x2 >= 48, name="carbohydrates_total")
model.addConstr(6*x0**2 - 2*x2**2 >= 0, name="slices_fruit_salads")
model.addConstr(10*x1 - 4*x2 >= 0, name="apple_pies_fruit_salads")
model.addConstr(18*x0 + 11*x1 <= 190, name="tastiness_pizza_apple_pies_limit")
model.addConstr(23*x0 + 13*x1 <= 117, name="carbohydrates_pizza_apple_pies_limit")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Slices of pizza: ", x0.varValue)
    print("Apple pies: ", x1.varValue)
    print("Fruit salads: ", x2.varValue)
else:
    print("The model is infeasible")
