
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # hours worked by Jean
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # hours worked by Dale


    # Set objective function
    model.setObjective(4*x0**2 + 9*x1*x2 + 6*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x0**2 + 7*x2**2 <= 209, "c0")
    model.addConstr(18*x0 + 23*x1 <= 134, "c1")
    model.addConstr(18*x0 + 23*x1 + 7*x2 <= 134, "c2")
    model.addConstr(23*x1 + 26*x2 <= 210, "c3")
    model.addConstr(11*x0 + 26*x2 <= 198, "c4")
    model.addConstr(11*x0 + 23*x1 + 26*x2 <= 198, "c5")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
