
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x1 = m.addVar(name="hours_worked_by_Jean", lb=0)
x2 = m.addVar(name="hours_worked_by_Dale", lb=0)

# Objective function
m.setObjective(4 * x0**2 + 9 * x1 * x2 + 6 * x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(18 * x0 <= 254)
m.addConstr(23 * x1 <= 253)
m.addConstr(7 * x2 <= 254)
m.addConstr(x0**2 + x2**2 <= 209)
m.addConstr(18 * x0 + 23 * x1 <= 134)
m.addConstr(18 * x0 + 23 * x1 + 7 * x2 <= 134)
m.addConstr(23 * x1 + 26 * x2 <= 210)
m.addConstr(11 * x0 + 26 * x2 <= 198)
m.addConstr(11 * x0 + 23 * x1 + 26 * x2 <= 198)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {x0.varValue}")
    print(f"Hours worked by Jean: {x1.varValue}")
    print(f"Hours worked by Dale: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
