
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    model.setObjective(8*x0**2 + 4*x0*x1 + 2*x0*x2 + 6*x1*x3 + 5*x2**2 + 8*x0 + 3*x2 + 4*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 12*x1 + 12*x2 + 11*x3 <= 213, "c0")
    model.addConstr(15*x0 + 17*x1 + 23*x2 + 22*x3 <= 140, "c1")
    model.addConstr(12*x1 + 11*x3 >= 20, "c2")
    model.addConstr(5*x0 + 12*x2 + 11*x3 >= 39, "c3")
    model.addConstr(5*x0 + 12*x1 + 12*x2 + 11*x3 >= 39, "c4")
    model.addConstr(15*x0 + 17*x1 >= 25, "c5")
    model.addConstr(17*x1 + 23*x2 >= 12, "c6")
    model.addConstr(15*x0**2 + 17*x1**2 + 22*x3**2 >= 18, "c7")
    model.addConstr(15*x0 + 17*x1 + 23*x2 + 22*x3 >= 18, "c8")
    model.addConstr(-4*x0 + 7*x1 >= 0, "c9")
    model.addConstr(15*x0 + 17*x1 + 23*x2 <= 134, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
