
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x1')  # milligrams of vitamin B7
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x2')  # milligrams of vitamin B4
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x3')  # grams of fiber
x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x4')  # grams of protein

# Objective function
model.setObjective(8*x1**2 + 4*x1*x2 + 2*x1*x3 + 6*x2*x4 + 5*x3**2 + 8*x1 + 3*x3 + 4*x4, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(5*x1 <= 213)
model.addConstr(15*x1 <= 140)
model.addConstr(12*x2 <= 213)
model.addConstr(17*x2 <= 140)
model.addConstr(12*x3 <= 213)
model.addConstr(23*x3 <= 140)
model.addConstr(11*x4 <= 213)
model.addConstr(22*x4 <= 140)
model.addConstr(12*x2 + 11*x4 >= 20)
model.addConstr(5*x1 + 12*x3 + 11*x4 >= 39)
model.addConstr(5*x1 + 12*x2 + 12*x3 + 11*x4 >= 39)
model.addConstr(15*x1 + 17*x2 >= 25)
model.addConstr(17*x2 + 23*x3 >= 12)
model.addConstr(225*x1**2 + 289*x2**2 + 484*x4**2 >= 18)
model.addConstr(15*x1 + 17*x2 + 23*x3 + 22*x4 >= 18)
model.addConstr(-4*x1 + 7*x2 >= 0)
model.addConstr(15*x1 + 17*x2 + 23*x3 <= 134)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('The model is infeasible')
