
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="peanutbutter sandwiches")
x1 = m.addVar(vtype=GRB.INTEGER, name="pickles")
x2 = m.addVar(vtype=GRB.INTEGER, name="green beans")


# Set objective function
m.setObjective(9*x0**2 + 9*x0*x1 + 5*x0*x2 + 5*x1**2 + 4*x1*x2 + 1*x0 + 7*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x0 + 13*x2 >= 15, "tastiness_constraint1")
m.addConstr(12*x0 + 1*x1 + 13*x2 >= 15, "tastiness_constraint2")
m.addConstr(4*x1 + 12*x2 >= 19, "fat_constraint1")
m.addConstr(2*x0 + 4*x1 >= 15, "fat_constraint2")
m.addConstr(2*x0 + 4*x1 + 12*x2 >= 15, "fat_constraint3")
m.addConstr(10*x1 - 5*x2 >= 0, "constraint4")
m.addConstr(2*x0 + 4*x1 + 12*x2 <= 138, "fat_constraint4")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter sandwiches:', x0.x)
    print('pickles:', x1.x)
    print('green beans:', x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

