
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="pickles", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="green_beans", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9*x0**2 + 9*x0*x1 + 5*x0*x2 + 5*x1**2 + 4*x1*x2 + x0 + 7*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12*x0 == 12)
    model.addConstr(2*x0 == 2)
    model.addConstr(x1 == 1)
    model.addConstr(4*x1 == 4)
    model.addConstr(13*x2 == 13)
    model.addConstr(12*x2 == 12)
    model.addConstr(12*x0 + 13*x2 >= 15)
    model.addConstr(12*x0 + x1 + 13*x2 >= 15)
    model.addConstr(4*x1 + 12*x2 >= 19)
    model.addConstr(2*x0 + 4*x1 >= 15)
    model.addConstr(2*x0 + 4*x1 + 12*x2 >= 15)
    model.addConstr(10*x1 - 5*x2 >= 0)
    model.addConstr(2*x0 + 4*x1 + 12*x2 <= 138)

    # Bounds
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("No solution found")

optimization_problem()
