
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("employee_scheduling")

    # Create variables
    laura_hours = m.addVar(name="laura_hours")
    bobby_hours = m.addVar(name="bobby_hours")
    george_hours = m.addVar(name="george_hours")


    # Set objective function
    m.setObjective(6.73 * laura_hours + 3.92 * bobby_hours + 1.71 * george_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * laura_hours + 27 * bobby_hours >= 55, "c1")
    m.addConstr(11 * laura_hours + 6 * george_hours >= 44, "c2")
    m.addConstr(21 * bobby_hours + 6 * george_hours >= 26, "c3")
    m.addConstr(11 * laura_hours + 21 * bobby_hours + 6 * george_hours >= 36, "c4")
    m.addConstr(20 * laura_hours + 27 * bobby_hours <= 248, "c5")
    m.addConstr(27 * bobby_hours + 19 * george_hours <= 231, "c6")
    m.addConstr(20 * laura_hours + 27 * bobby_hours + 19 * george_hours <= 231, "c7")
    m.addConstr(28 * laura_hours + 32 * bobby_hours <= 226, "c8")
    m.addConstr(32 * bobby_hours + 23 * george_hours <= 126, "c9")
    m.addConstr(28 * laura_hours + 32 * bobby_hours + 23 * george_hours <= 126, "c10")
    m.addConstr(11 * laura_hours + 21 * bobby_hours <= 89, "c11")
    m.addConstr(11 * laura_hours + 6 * george_hours <= 88, "c12")
    m.addConstr(11 * laura_hours + 21 * bobby_hours + 6 * george_hours <= 74, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('George Hours: %g' % george_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other optimization status')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
