
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=0, name='hours_worked_by_Laura')
    x1 = model.addVar(lb=0, name='hours_worked_by_Bobby')
    x2 = model.addVar(lb=0, name='hours_worked_by_George')
    
    # Define objective function
    model.setObjective(6.73*x0 + 3.92*x1 + 1.71*x2, gurobi.GRB.MAXIMIZE)
    
    # Define constraints
    model.addConstr(20*x0 + 27*x1 >= 55, name='likelihood_to_quit_Laura_Bobby')
    model.addConstr(11*x0 + 6*x2 >= 44, name='computer_competence_Laura_George')
    model.addConstr(21*x1 + 6*x2 >= 26, name='computer_competence_Bobby_George')
    model.addConstr(11*x0 + 21*x1 + 6*x2 >= 36, name='computer_competence_all')
    model.addConstr(20*x0 + 27*x1 <= 248, name='likelihood_to_quit_Laura_Bobby_max')
    model.addConstr(27*x1 + 19*x2 <= 231, name='likelihood_to_quit_Bobby_George_max')
    model.addConstr(20*x0 + 27*x1 + 19*x2 <= 330, name='likelihood_to_quit_all_max')
    model.addConstr(28*x0 + 32*x1 <= 226, name='dollar_cost_Laura_Bobby_max')
    model.addConstr(32*x1 + 23*x2 <= 126, name='dollar_cost_Bobby_George_max')
    model.addConstr(28*x0 + 32*x1 + 23*x2 <= 248, name='dollar_cost_all_max')
    model.addConstr(11*x0 + 21*x1 <= 89, name='computer_competence_Laura_Bobby_max')
    model.addConstr(11*x0 + 6*x2 <= 88, name='computer_competence_Laura_George_max')
    model.addConstr(11*x0 + 21*x1 + 6*x2 <= 74, name='computer_competence_all_max')
    
    # Solve the model
    model.optimize()
    
    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Laura: ', x0.x)
        print('Hours worked by Bobby: ', x1.x)
        print('Hours worked by George: ', x2.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
