
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(4*x0 + 1*x1 + 8*x2 + 3*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(30*x0 + 8*x1 + 16*x2 + 21*x3 <= 236)
    m.addConstr(6*x0 + 20*x1 + 12*x2 + 16*x3 <= 231)
    m.addConstr(8*x1 + 16*x2 >= 34)
    m.addConstr(30*x0 + 16*x2 >= 24)
    m.addConstr(16*x2 + 21*x3 >= 54)
    m.addConstr(8*x1 + 21*x3 >= 34)
    m.addConstr(30*x0 + 8*x1 + 16*x2 + 21*x3 >= 34)
    m.addConstr(20*x1 + 12*x2 >= 41)
    m.addConstr(12*x2 + 16*x3 >= 25)
    m.addConstr(6*x0 + 12*x2 >= 50)
    m.addConstr(6*x0 + 16*x3 >= 57)
    m.addConstr(20*x1 + 16*x3 >= 22)
    m.addConstr(6*x0 + 20*x1 + 12*x2 >= 34)
    m.addConstr(6*x0 + 20*x1 + 16*x3 >= 34)
    m.addConstr(20*x1 + 12*x2 + 16*x3 >= 34)
    m.addConstr(6*x0 + 20*x1 + 12*x2 >= 39)
    m.addConstr(6*x0 + 20*x1 + 16*x3 >= 39)
    m.addConstr(20*x1 + 12*x2 + 16*x3 >= 39)
    m.addConstr(6*x0 + 20*x1 + 12*x2 >= 43)
    m.addConstr(6*x0 + 20*x1 + 16*x3 >= 43)
    m.addConstr(20*x1 + 12*x2 + 16*x3 >= 43)
    m.addConstr(6*x0 + 20*x1 + 12*x2 + 16*x3 >= 43)
    m.addConstr(2*x1 - 7*x3 >= 0)
    m.addConstr(-9*x0 + x3 >= 0)
    m.addConstr(30*x0 + 21*x3 <= 168)
    m.addConstr(8*x1 + 21*x3 <= 71)
    m.addConstr(8*x1 + 16*x2 <= 74)
    m.addConstr(16*x2 + 21*x3 <= 113)
    m.addConstr(6*x0 + 20*x1 + 16*x3 <= 96)
    m.addConstr(6*x0 + 20*x1 + 12*x2 <= 197)
    m.addConstr(6*x0 + 12*x2 + 16*x3 <= 187)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
