
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B3
    x2 = model.addVar(name="x2", lb=0)  # grams of protein
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B7
    x4 = model.addVar(name="x4", lb=0)  # milligrams of magnesium

    # Objective function
    model.setObjective(4 * x1 + x2 + 8 * x3 + 3 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(30 * x1 <= 236)
    model.addConstr(6 * x1 <= 231)
    model.addConstr(8 * x2 <= 236)
    model.addConstr(20 * x2 <= 231)
    model.addConstr(16 * x3 <= 236)
    model.addConstr(12 * x3 <= 231)
    model.addConstr(21 * x4 <= 236)
    model.addConstr(16 * x4 <= 231)
    model.addConstr(8 * x2 + 16 * x3 >= 34)
    model.addConstr(30 * x1 + 16 * x3 >= 24)
    model.addConstr(16 * x3 + 21 * x4 >= 54)
    model.addConstr(8 * x2 + 21 * x4 >= 34)
    model.addConstr(30 * x1 + 8 * x2 + 16 * x3 + 21 * x4 >= 34)
    model.addConstr(20 * x2 + 12 * x3 >= 41)
    model.addConstr(12 * x3 + 16 * x4 >= 25)
    model.addConstr(6 * x1 + 12 * x3 >= 50)
    model.addConstr(6 * x1 + 16 * x4 >= 57)
    model.addConstr(20 * x2 + 16 * x4 >= 22)
    model.addConstr(6 * x1 + 20 * x2 + 12 * x3 >= 34)
    model.addConstr(6 * x1 + 20 * x2 + 16 * x4 >= 34)
    model.addConstr(20 * x2 + 12 * x3 + 16 * x4 >= 34)
    model.addConstr(6 * x1 + 20 * x2 + 12 * x3 >= 39)
    model.addConstr(6 * x1 + 20 * x2 + 16 * x4 >= 39)
    model.addConstr(20 * x2 + 12 * x3 + 16 * x4 >= 39)
    model.addConstr(6 * x1 + 20 * x2 + 12 * x3 >= 43)
    model.addConstr(6 * x1 + 20 * x2 + 16 * x4 >= 43)
    model.addConstr(20 * x2 + 12 * x3 + 16 * x4 >= 43)
    model.addConstr(6 * x1 + 20 * x2 + 12 * x3 + 16 * x4 >= 43)
    model.addConstr(2 * x2 - 7 * x4 >= 0)
    model.addConstr(-9 * x1 + x4 >= 0)
    model.addConstr(30 * x1 + 21 * x4 <= 168)
    model.addConstr(8 * x2 + 21 * x4 <= 71)
    model.addConstr(8 * x2 + 16 * x3 <= 74)
    model.addConstr(16 * x3 + 21 * x4 <= 113)
    model.addConstr(6 * x1 + 20 * x2 + 16 * x4 <= 96)
    model.addConstr(6 * x1 + 20 * x2 + 12 * x3 <= 197)
    model.addConstr(6 * x1 + 12 * x3 + 16 * x4 <= 187)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
