
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Laura
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Bill
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Paul
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # hours worked by George


    # Set objective function
    m.setObjective(5*x0 + 2*x1 + 5*x2 + 7*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8.22*x1 + 11.31*x3 >= 39)
    m.addConstr(8.35*x0 + 9.77*x2 >= 12)
    m.addConstr(8.35*x0 + 4.64*x1 >= 13)
    m.addConstr(2.91*x2 + 1.13*x3 >= 26)
    m.addConstr(1.15*x1 + 0.49*x2 >= 7)
    m.addConstr(0.8*x0 + 0.49*x2 >= 16)
    m.addConstr(0.8*x0 + 1.15*x1 >= 7)
    m.addConstr(10*x1 - 9*x2 - 10*x3 >= 0)
    m.addConstr(8.22*x1 + 11.31*x3 <= 68)
    m.addConstr(1.09*x0 + 10.62*x2 <= 139)
    m.addConstr(8.22*x1 + 10.62*x2 <= 207)
    m.addConstr(1.09*x0 + 8.22*x1 <= 126)
    m.addConstr(1.09*x0 + 10.62*x2 + 11.31*x3 <= 71)
    m.addConstr(1.09*x0 + 8.22*x1 + 10.62*x2 + 11.31*x3 <= 71)
    m.addConstr(4.64*x1 + 9.77*x2 <= 83)
    m.addConstr(9.77*x2 + 4.76*x3 <= 43)
    m.addConstr(8.35*x0 + 4.64*x1 + 9.77*x2 + 4.76*x3 <= 43)
    m.addConstr(0.95*x0 + 2.91*x2 <= 182)
    m.addConstr(0.95*x0 + 1.13*x3 <= 180)
    m.addConstr(2.91*x2 + 1.13*x3 <= 164)
    m.addConstr(6.37*x1 + 2.91*x2 <= 149)
    m.addConstr(0.95*x0 + 6.37*x1 + 2.91*x2 + 1.13*x3 <= 149)
    m.addConstr(0.49*x2 + 7.4*x3 <= 33)
    m.addConstr(1.15*x1 + 0.49*x2 <= 54)
    m.addConstr(0.8*x0 + 0.49*x2 + 7.4*x3 <= 26)
    m.addConstr(0.8*x0 + 1.15*x1 + 7.4*x3 <= 23)
    m.addConstr(1.15*x1 + 0.49*x2 + 7.4*x3 <= 65)
    m.addConstr(0.8*x0 + 1.15*x1 + 0.49*x2 <= 19)
    m.addConstr(0.8*x0 + 1.15*x1 + 0.49*x2 + 7.4*x3 <= 19)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
