
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name='x0', vtype=gp.GRB.INTEGER)  # hours worked by Laura
x1 = m.addVar(name='x1')  # hours worked by Bill
x2 = m.addVar(name='x2')  # hours worked by Paul
x3 = m.addVar(name='x3')  # hours worked by George

# Define the objective function
m.setObjective(5 * x0 + 2 * x1 + 5 * x2 + 7 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.22 * x1 + 11.31 * x3 >= 39)
m.addConstr(8.35 * x0 + 9.77 * x2 >= 12)
m.addConstr(8.35 * x0 + 4.64 * x1 >= 13)
m.addConstr(2.91 * x2 + 1.13 * x3 >= 26)
m.addConstr(1.15 * x1 + 0.49 * x2 >= 7)
m.addConstr(0.8 * x0 + 0.49 * x2 >= 16)
m.addConstr(0.8 * x0 + 1.15 * x1 >= 7)
m.addConstr(10 * x1 - 9 * x2 - 10 * x3 >= 0)
m.addConstr(8.22 * x1 + 11.31 * x3 <= 68)
m.addConstr(1.09 * x0 + 10.62 * x2 <= 139)
m.addConstr(8.22 * x1 + 2.91 * x2 <= 207)
m.addConstr(1.09 * x0 + 8.22 * x1 <= 126)
m.addConstr(1.09 * x0 + 10.62 * x2 + 11.31 * x3 <= 71)
m.addConstr(1.09 * x0 + 8.22 * x1 + 10.62 * x2 + 11.31 * x3 <= 71)
m.addConstr(4.64 * x1 + 9.77 * x2 <= 83)
m.addConstr(9.77 * x2 + 4.76 * x3 <= 43)
m.addConstr(8.35 * x0 + 4.64 * x1 + 9.77 * x2 + 4.76 * x3 <= 43)
m.addConstr(0.95 * x0 + 2.91 * x2 <= 182)
m.addConstr(0.95 * x0 + 1.13 * x3 <= 180)
m.addConstr(2.91 * x2 + 1.13 * x3 <= 164)
m.addConstr(6.37 * x1 + 2.91 * x2 <= 149)
m.addConstr(0.95 * x0 + 6.37 * x1 + 2.91 * x2 + 1.13 * x3 <= 149)
m.addConstr(0.49 * x2 + 7.4 * x3 <= 33)
m.addConstr(1.15 * x1 + 0.49 * x2 <= 54)
m.addConstr(0.8 * x0 + 0.49 * x2 + 7.4 * x3 <= 26)
m.addConstr(0.8 * x0 + 1.15 * x1 + 7.4 * x3 <= 23)
m.addConstr(1.15 * x1 + 0.49 * x2 + 7.4 * x3 <= 65)
m.addConstr(0.8 * x0 + 1.15 * x1 + 0.49 * x2 <= 19)
m.addConstr(0.8 * x0 + 1.15 * x1 + 0.49 * x2 + 7.4 * x3 <= 19)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
