
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Peggy")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Laura")


    # Set objective function
    model.setObjective(9*x0 + 6*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x0 + 14*x1 >= 26, "c0")
    model.addConstr(1*x0 + 9*x1 >= 8, "c1")
    model.addConstr(14*x0 + 12*x1 >= 12, "c2")
    model.addConstr(12*x0 + 14*x1 >= 6, "c3")
    model.addConstr(2*x0 - 2*x1 >= 0, "c4")
    model.addConstr(10*x0 + 14*x1 <= 73, "c5")
    model.addConstr(1*x0 + 9*x1 <= 25, "c6")
    model.addConstr(14*x0 + 12*x1 <= 30, "c7")
    model.addConstr(12*x0 + 14*x1 <= 40, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
