
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="hours_worked_by_Laura", lb=0)  # hours worked by Laura

    # Define the objective function
    model.setObjective(9 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 14 * x2 >= 26)  # total combined paperwork competence rating
    model.addConstr(1 * x1 + 9 * x2 >= 8)  # total combined computer competence rating
    model.addConstr(14 * x1 + 12 * x2 >= 12)  # total combined dollar cost per hour
    model.addConstr(12 * x1 + 14 * x2 >= 6)  # total combined work quality rating
    model.addConstr(2 * x1 - 2 * x2 >= 0)  # relationship between hours worked by Peggy and Laura
    model.addConstr(10 * x1 + 14 * x2 <= 73)  # upper bound on total combined paperwork competence rating
    model.addConstr(1 * x1 + 9 * x2 <= 25)  # upper bound on total combined computer competence rating
    model.addConstr(14 * x1 + 12 * x2 <= 30)  # upper bound on total combined dollar cost per hour
    model.addConstr(12 * x1 + 14 * x2 <= 40)  # upper bound on total combined work quality rating

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Laura: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
