
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
    eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
    hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
    rotisserie_chickens = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

    # Set objective function
    m.setObjective(9*apples**2 + 5*apples*eggs + 3*apples*rotisserie_chickens + 9*eggs*hamburgers + 9*hamburgers**2 + 8*rotisserie_chickens**2 + 5*apples + 6*eggs + 2*hamburgers + 4*rotisserie_chickens, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(hamburgers + rotisserie_chickens >= 15)
    m.addConstr(eggs + hamburgers >= 15)
    m.addConstr(eggs + rotisserie_chickens >= 10)
    m.addConstr(apples + rotisserie_chickens >= 26)
    m.addConstr(apples + eggs + hamburgers + rotisserie_chickens >= 26)
    m.addConstr(3*apples + 8*hamburgers >= 42)
    m.addConstr(6*eggs + rotisserie_chickens >= 19)
    m.addConstr(8*hamburgers + rotisserie_chickens >= 19)
    m.addConstr(3*apples + 6*eggs >= 43)
    m.addConstr(6*eggs**2 + 8*hamburgers**2 + rotisserie_chickens**2 >= 52)
    m.addConstr(3*apples**2 + 6*eggs**2 + 8*hamburgers**2 >= 52)
    m.addConstr(6*eggs**2 + 8*hamburgers**2 + rotisserie_chickens**2 >= 41)
    m.addConstr(3*apples + 6*eggs + 8*hamburgers >= 41)
    m.addConstr(3*apples + 6*eggs + 8*hamburgers + rotisserie_chickens >= 41)
    m.addConstr(apples**2 + rotisserie_chickens**2 <= 89)
    m.addConstr(apples**2 + eggs**2 + hamburgers**2 <= 58)
    m.addConstr(6*eggs + 8*hamburgers <= 72)
    m.addConstr(3*apples + 8*hamburgers + rotisserie_chickens <= 101)
    m.addConstr(3*apples**2 + 6*eggs**2 + 8*hamburgers**2 <= 89)
    m.addConstr(3*apples**2 + 6*eggs**2 + rotisserie_chickens**2 <= 172)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
