
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="apples", lb=-gurobi.GRB.INFINITY)
x1 = m.addVar(name="eggs", lb=-gurobi.GRB.INFINITY)
x2 = m.addVar(name="hamburgers", lb=-gurobi.GRB.INFINITY)
x3 = m.addVar(name="rotisserie_chickens", lb=-gurobi.GRB.INFINITY)

# Objective function
m.setObjective(9*x0**2 + 5*x0*x1 + 3*x0*x3 + 9*x1*x2 + 9*x2**2 + 8*x3**2 + 5*x0 + 6*x1 + 2*x2 + 4*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(10*x2 + 4*x3 >= 15)
m.addConstr(20*x1 + 10*x2 >= 15)
m.addConstr(20*x1 + 4*x3 >= 10)
m.addConstr(x0 + 4*x3 >= 26)
m.addConstr(x0 + 20*x1 + 10*x2 + 4*x3 >= 26)
m.addConstr(3*x0 + 8*x2 >= 42)
m.addConstr(6*x1 + x3 >= 19)
m.addConstr(8*x2 + x3 >= 19)
m.addConstr(3*x0 + 6*x1 >= 43)
m.addConstr(6*x1**2 + 8*x2**2 + x3**2 >= 52)
m.addConstr(3*x0**2 + 6*x1**2 + 8*x2**2 >= 52)
m.addConstr(6*x1**2 + 8*x2**2 + x3**2 >= 41)
m.addConstr(3*x0 + 6*x1 + 8*x2 >= 41)
m.addConstr(3*x0 + 6*x1 + 8*x2 + x3 >= 41)
m.addConstr(x0**2 + x3**2 <= 89)
m.addConstr(x0**2 + 400*x1**2 + 100*x2**2 <= 58)
m.addConstr(6*x1 + 8*x2 <= 72)
m.addConstr(3*x0 + 8*x2 + x3 <= 101)
m.addConstr(3*x0**2 + 6*x1**2 + 8*x2**2 <= 89)
m.addConstr(3*x0**2 + 6*x1**2 + x3**2 <= 172)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apples: ", x0.varValue)
    print("Eggs: ", x1.varValue)
    print("Hamburgers: ", x2.varValue)
    print("Rotisserie Chickens: ", x3.varValue)
else:
    print("The model is infeasible")
