
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
cantaloupes = model.addVar(vtype=GRB.INTEGER, name="cantaloupes")
chicken_drumsticks = model.addVar(vtype=GRB.INTEGER, name="chicken_drumsticks")
tomatoes = model.addVar(vtype=GRB.INTEGER, name="tomatoes")
bowls_of_cereal = model.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")
bowls_of_pasta = model.addVar(vtype=GRB.INTEGER, name="bowls_of_pasta")
bowls_of_instant_ramen = model.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramen")
corn_cobs = model.addVar(vtype=GRB.INTEGER, name="corn_cobs")


# Set objective function
model.setObjective(5*cantaloupes + 2*chicken_drumsticks + 8*tomatoes + 9*bowls_of_cereal + 9*bowls_of_pasta + 1*bowls_of_instant_ramen + 2*corn_cobs, GRB.MINIMIZE)

# Add constraints
model.addConstr(7*cantaloupes + 9*chicken_drumsticks + 6*tomatoes + 10*bowls_of_cereal + 10*bowls_of_pasta + 9*bowls_of_instant_ramen + 11*corn_cobs <= 304, "calcium_upper_bound")

for constraint in json_data["constraints"]:
    model.addConstr(eval(constraint))


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

