
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="chicken drumsticks", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="tomatoes", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="bowls of cereal", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="bowls of pasta", vtype=gurobi.GRB.INTEGER)
    x6 = model.addVar(name="bowls of instant ramen", vtype=gurobi.GRB.INTEGER)
    x7 = model.addVar(name="corn cobs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5*x1 + 2*x2 + 8*x3 + 9*x4 + 9*x5 + 1*x6 + 2*x7, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7*x1 + 9*x2 + 6*x3 + 10*x4 + 10*x5 + 9*x6 + 11*x7 <= 304)
    model.addConstr(x4 + x7 >= 32)
    model.addConstr(x4 + x5 >= 15)
    model.addConstr(x3 + x7 >= 24)
    model.addConstr(x5 + x7 >= 26)
    model.addConstr(x4 + x6 >= 28)
    model.addConstr(x3 + x5 >= 15)
    model.addConstr(x1 + x3 >= 23)
    model.addConstr(x5 + x6 >= 24)
    model.addConstr(x1 + x5 >= 32)
    model.addConstr(x1 + x2 >= 40)
    model.addConstr(x3 + x5 + x6 >= 32)
    model.addConstr(x1 + x3 + x7 >= 32)
    model.addConstr(x1 + x2 + x4 >= 32)
    model.addConstr(x3 + x5 + x7 >= 32)
    model.addConstr(x1 + x6 + x7 >= 32)
    model.addConstr(x2 + x3 + x4 >= 32)
    model.addConstr(x1 + x2 + x6 >= 32)
    model.addConstr(x1 + x4 + x6 >= 32)
    model.addConstr(x1 + x4 + x5 >= 32)
    model.addConstr(x4 + x6 + x7 >= 32)
    model.addConstr(x4 + x5 + x6 >= 32)
    model.addConstr(x1 + x2 + x5 >= 32)
    model.addConstr(x5 + x6 + x7 >= 32)
    model.addConstr(x2 + x4 + x5 >= 32)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("cantaloupes: ", x1.varValue)
        print("chicken drumsticks: ", x2.varValue)
        print("tomatoes: ", x3.varValue)
        print("bowls of cereal: ", x4.varValue)
        print("bowls of pasta: ", x5.varValue)
        print("bowls of instant ramen: ", x6.varValue)
        print("corn cobs: ", x7.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
