
import gurobipy as gp

# Create a new model
m = gp.Model("protein_optimization")

# Create variables
kiwis = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")
knishes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="knishes")
ramen = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ramen")

# Set objective function
m.setObjective(3 * kiwis + 4 * knishes + 3 * ramen, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * knishes + 7 * ramen <= 65, "protein_constraint1")
m.addConstr(4 * kiwis + 7 * ramen <= 101, "protein_constraint2")
m.addConstr(4 * kiwis + 2 * knishes + 7 * ramen <= 120, "protein_constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('kiwis:', kiwis.x)
    print('knishes:', knishes.x)
    print('ramen:', ramen.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

