
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(name="kiwis", lb=0)  # Amount of kiwis
x2 = m.addVar(name="knishes", lb=0)  # Quantity of knishes
x3 = m.addVar(name="bowls_of_instant_ramen", lb=0)  # Quantity of bowls of instant ramen

# Set the objective function
m.setObjective(3*x1 + 4*x2 + 3*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 2*x2 + 7*x3 <= 120, name="Total_protein_from_all_items")
m.addConstr(2*x2 + 7*x3 <= 65, name="Protein_from_knishes_and_ramen")
m.addConstr(4*x1 + 7*x3 <= 101, name="Protein_from_kiwis_and_ramen")
m.addConstr(4*x1 + 2*x2 + 7*x3 <= 101, name="Total_protein_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {x1.x}")
    print(f"Knishes: {x2.x}")
    print(f"Bowls of instant ramen: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
