
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='kiwis', lb=0)  # Lower bound is 0, assuming we can't have negative quantities
x2 = model.addVar(name='knishes', lb=0)
x3 = model.addVar(name='bowls of instant ramen', lb=0)

# Set the objective function
model.setObjective(3*x1 + 4*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x2 + 7*x3 <= 65)
model.addConstr(4*x1 + 7*x3 <= 101)
model.addConstr(4*x1 + 2*x2 + 7*x3 <= 120)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Kiwis: ', x1.varValue)
    print('Knishes: ', x2.varValue)
    print('Bowls of instant ramen: ', x3.varValue)
else:
    print('The model is infeasible')
