
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.CONTINUOUS, name="x0") # hours worked by Jean
    x1 = model.addVar(vtype=GRB.INTEGER, name="x1") # hours worked by Peggy
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="x2") # hours worked by Hank


    # Set objective function
    model.setObjective(4*x0**2 + 7*x0*x1 + x2**2 + 4*x0, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x0 + 17*x2 >= 21, "c0")
    model.addConstr(17*x1 + 17*x2 >= 29, "c1")
    model.addConstr(7*x0**2 + 17*x1**2 + 17*x2**2 >= 37, "c2")
    model.addConstr(7*x0 + 17*x1 + 17*x2 >= 37, "c3")
    model.addConstr(19*x1**2 + 9*x2**2 >= 14, "c4")
    model.addConstr(13*x0 + 9*x2 >= 25, "c5")
    model.addConstr(13*x0 + 19*x1 + 9*x2 >= 25, "c6")
    model.addConstr(18*x1 + 13*x2 >= 36, "c7")
    model.addConstr(17*x0**2 + 18*x1**2 >= 59, "c8")
    model.addConstr(17*x0**2 + 13*x2**2 >= 44, "c9")
    model.addConstr(17*x0 + 18*x1 + 13*x2 >= 55, "c10")
    model.addConstr(17*x0 + 18*x1 + 13*x2 >= 55, "c11")
    model.addConstr(7*x0 + 17*x2 >= 59, "c12")
    model.addConstr(7*x0 + 3*x1 >= 56, "c13")
    model.addConstr(7*x0 + 3*x1 + 17*x2 >= 50, "c14")
    model.addConstr(7*x0 + 3*x1 + 17*x2 >= 50, "c15")
    model.addConstr(-x0 + 5*x2 >= 0, "c16")
    model.addConstr(7*x0**2 + 17*x2**2 <= 95, "c17")
    model.addConstr(17*x1 + 17*x2 <= 68, "c18")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Other optimization status code:', model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
