
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # hours worked by Jean
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x1")  # hours worked by Peggy
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # hours worked by Hank

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + x2**2 + 4*x0, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(7*x0 >= 7, name="c1")
m.addConstr(13*x0 >= 13, name="c2")
m.addConstr(17*x0 >= 17, name="c3")
m.addConstr(7*x0 >= 7, name="c4")
m.addConstr(17*x1 >= 17, name="c5")
m.addConstr(19*x1 >= 19, name="c6")
m.addConstr(18*x1 >= 18, name="c7")
m.addConstr(3*x1 >= 3, name="c8")
m.addConstr(17*x2 >= 17, name="c9")
m.addConstr(9*x2 >= 9, name="c10")
m.addConstr(13*x2 >= 13, name="c11")
m.addConstr(17*x2 >= 17, name="c12")
m.addConstr(7*x0 + 17*x2 >= 21, name="c13")
m.addConstr(17*x1 + 17*x2 >= 29, name="c14")
m.addConstr(7*x0**2 + 17*x1**2 + 17*x2**2 >= 37, name="c15")
m.addConstr(7*x0 + 17*x1 + 17*x2 >= 37, name="c16")
m.addConstr(19*x1**2 + 9*x2**2 >= 14, name="c17")
m.addConstr(13*x0 + 9*x2 >= 25, name="c18")
m.addConstr(13*x0 + 19*x1 + 9*x2 >= 25, name="c19")
m.addConstr(18*x1 + 13*x2 >= 36, name="c20")
m.addConstr(17*x0**2 + 18*x1**2 >= 59, name="c21")
m.addConstr(17*x0**2 + 13*x2**2 >= 44, name="c22")
m.addConstr(17*x0 + 18*x1 + 13*x2 >= 55, name="c23")
m.addConstr(7*x0 + 3*x1 + 17*x2 >= 59, name="c24")
m.addConstr(7*x0 + 3*x1 >= 56, name="c25")
m.addConstr(7*x0 + 3*x1 + 17*x2 >= 50, name="c26")
m.addConstr(-x0 + 5*x2 >= 0, name="c27")
m.addConstr(7*x0**2 + 13*x2**2 <= 95, name="c28")
m.addConstr(17*x1 + 17*x2 <= 68, name="c29")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
