
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
cantaloupes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")

# Set objective function
m.setObjective(7 * cornichons + 9 * bowls_of_pasta + 2 * corn_cobs + 8 * cantaloupes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.56 * corn_cobs + 0.04 * cantaloupes >= 31)
m.addConstr(6.09 * bowls_of_pasta + 3.56 * corn_cobs + 0.04 * cantaloupes >= 37)
m.addConstr(3.85 * cornichons + 3.56 * corn_cobs + 0.04 * cantaloupes >= 37)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta + 0.04 * cantaloupes >= 37)
m.addConstr(6.09 * bowls_of_pasta + 3.56 * corn_cobs + 0.04 * cantaloupes >= 20)
m.addConstr(3.85 * cornichons + 3.56 * corn_cobs + 0.04 * cantaloupes >= 20)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta + 0.04 * cantaloupes >= 20)
m.addConstr(6.09 * bowls_of_pasta + 3.56 * corn_cobs + 0.04 * cantaloupes >= 34)
m.addConstr(3.85 * cornichons + 3.56 * corn_cobs + 0.04 * cantaloupes >= 34)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta + 0.04 * cantaloupes >= 34)
m.addConstr(6.02 * cornichons + 2.73 * corn_cobs >= 13)
m.addConstr(6.02 * cornichons + 2.51 * cantaloupes >= 11)
m.addConstr(6.74 * bowls_of_pasta + 2.73 * corn_cobs >= 9)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta <= 69)
m.addConstr(3.85 * cornichons + 0.04 * cantaloupes <= 104)
m.addConstr(3.85 * cornichons + 3.56 * corn_cobs <= 102)
m.addConstr(6.09 * bowls_of_pasta + 0.04 * cantaloupes <= 78)
m.addConstr(6.09 * bowls_of_pasta + 3.56 * corn_cobs <= 54)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta + 3.56 * corn_cobs <= 69)
m.addConstr(3.85 * cornichons + 6.09 * bowls_of_pasta + 3.56 * corn_cobs + 0.04 * cantaloupes <= 69)
m.addConstr(6.02 * cornichons + 2.73 * corn_cobs <= 50)
m.addConstr(6.02 * cornichons + 6.74 * bowls_of_pasta <= 35)
m.addConstr(6.74 * bowls_of_pasta + 2.51 * cantaloupes <= 65)
m.addConstr(6.02 * cornichons + 2.73 * corn_cobs + 2.51 * cantaloupes <= 42)
m.addConstr(6.02 * cornichons + 6.74 * bowls_of_pasta + 2.73 * corn_cobs + 2.51 * cantaloupes <= 42)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

