
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")


    # Set objective function
    model.setObjective(5.75*x0**2 + 5.18*x0*x1 + 3.76*x0, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.02*x0 + 4.73*x1 >= 19, "c0")
    model.addConstr(0.3*x0 + 1.69*x1 >= 44, "c1")
    model.addConstr(1.34*x0 + 0.4*x1 >= 65, "c2")
    model.addConstr(2.7*x0 + 0.65*x1 >= 41, "c3")
    model.addConstr(-8*x0 + 9*x1 >= 0, "c4")
    model.addConstr(1.02*x0 + 4.73*x1 <= 78, "c5")
    model.addConstr(0.3*x0**2 + 1.69*x1**2 <= 54, "c6")
    model.addConstr(1.34*x0**2 + 0.4*x1**2 <= 102, "c7")
    model.addConstr(2.7*x0**2 + 0.65*x1**2 <= 198, "c8")
    model.addConstr(x0**2 + x1**2 >= 19, "c9")



    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Airborne Infantry Companies: {x0.x}")
        print(f"Engineer Platoons: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
